/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer.transcription;

import de.mallongigi.file.FileUtil;
import de.mallongigi.mediaplayer.transcription.TranscriptionClient;
import de.mallongigi.mediaplayer.transcription.TranscriptionJSONParser;
import de.mallongigi.mediaplayer.transcription.TranscriptionPart;
import de.mallongigi.mediaplayer.transcription.TranscriptionVTTParser;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.ui.concurrent.JavaFXUtil;
import de.mallongigi.ui.elements.HTMLView;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EpisodeTranscription {
    private static final Logger LOG = Logger.getLogger(EpisodeTranscription.class.getName());
    private List<TranscriptionPart> parts = new ArrayList<TranscriptionPart>();
    private final ExecutorService downloadPool = Executors.newFixedThreadPool(1);
    private final HTMLView view;
    private TranscriptionPart currentTranscriptionPart;

    public EpisodeTranscription(HTMLView view) {
        this.view = view;
    }

    public void setEpisode(final PodcastEpisodeModel pem) {
        this.downloadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JavaFXUtil.runLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Path file = EpisodeTranscription.this.getTranscriptionLocalFile(pem);
                                if (Files.exists(file, new LinkOption[0])) {
                                    EpisodeTranscription.this.parts = new TranscriptionJSONParser().parse(file);
                                } else {
                                    TranscriptionClient connection = new TranscriptionClient(pem);
                                    connection.load();
                                    if (connection.hasContent()) {
                                        switch (connection.getLocation().type()) {
                                            case JSON: {
                                                EpisodeTranscription.this.parts = new TranscriptionJSONParser().parse(connection.getContent());
                                                break;
                                            }
                                            case VTT: {
                                                EpisodeTranscription.this.parts = new TranscriptionVTTParser().parse(connection.getContent());
                                            }
                                        }
                                    }
                                    EpisodeTranscription.this.save(pem);
                                }
                            }
                            catch (Exception e) {
                                LOG.log(Level.INFO, e.getMessage(), e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void setCurrentPlayTime(long time) {
        if (this.parts.isEmpty()) {
            return;
        }
        if (this.currentTranscriptionPart != null && this.currentTranscriptionPart.getStart() <= time && this.currentTranscriptionPart.getEnd() >= time) {
            this.show(this.currentTranscriptionPart);
        }
        for (TranscriptionPart p : this.parts) {
            if (p.getStart() > time || p.getEnd() < time) continue;
            this.currentTranscriptionPart = p;
            this.show(p);
            return;
        }
    }

    private void save(PodcastEpisodeModel pem) {
        try {
            if (this.parts.isEmpty()) {
                return;
            }
            JsonArrayBuilder contentList = Json.createArrayBuilder();
            for (TranscriptionPart tp : this.parts) {
                JsonObjectBuilder part = Json.createObjectBuilder();
                try {
                    part.add("start", tp.getStart().longValue());
                    part.add("end", tp.getEnd().longValue());
                    part.add("speaker", tp.getSpeaker());
                    part.add("speakerColor", tp.getSpeakerColor());
                    part.add("text", tp.getText());
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                contentList.add(part);
            }
            Files.writeString(this.getTranscriptionLocalFile(pem), (CharSequence)contentList.build().toString(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private Path getTranscriptionLocalFile(PodcastEpisodeModel pem) throws Exception {
        Path file = FileSystems.getDefault().getPath(FileUtil.getPodcastLocaleChapterDirectory(pem).toFile().getAbsolutePath(), "transcription.json");
        return file;
    }

    private void show(TranscriptionPart p) {
        this.view.setAttributeByElementId("speaker", "style", "color:" + p.getSpeakerColor());
        this.view.setTextByElementId("speaker", p.getSpeaker() + ":");
        this.view.setTextByElementId("text", p.getText());
    }
}

