/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer.timebar;

import de.mallongigi.mediaplayer.audio.ChapterNavigation;
import de.mallongigi.mediaplayer.timebar.TimeBarState;
import de.mallongigi.mediaplayer.transcription.EpisodeTranscription;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.time.DateTimeConverter;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;

public final class TimeBarService
extends Service<TimeBarState> {
    private final Slider timeBar;
    private final MediaView mediaView;
    private final Label startTimeLabel;
    private final Label endTimeLabel;
    private final ChapterNavigation chapterNavigation;
    private final EpisodeTranscription episodeTranscription;
    @Inject
    private DateTimeConverter dateTimeConverter;

    public TimeBarService(Slider timeBar, MediaView mediaView, Label startTimeLabel, Label endTimeLabel, ChapterNavigation chapterNavigation, EpisodeTranscription episodeTranscription) {
        this.timeBar = timeBar;
        this.mediaView = mediaView;
        this.startTimeLabel = startTimeLabel;
        this.endTimeLabel = endTimeLabel;
        this.chapterNavigation = chapterNavigation;
        this.episodeTranscription = episodeTranscription;
        Container.inject((Object)this);
    }

    protected Task<TimeBarState> createTask() {
        Task<TimeBarState> task = new Task<TimeBarState>(){

            protected TimeBarState call() {
                if (TimeBarService.this.timeBar.getUserData() != null && ((Boolean)TimeBarService.this.timeBar.getUserData()).booleanValue()) {
                    return null;
                }
                MediaPlayer player = TimeBarService.this.mediaView.getMediaPlayer();
                TimeBarState result = new TimeBarState(player.getCurrentTime().toMillis(), player.getMedia().getDuration().toMillis());
                return result;
            }
        };
        return task;
    }

    protected void succeeded() {
        TimeBarState value = (TimeBarState)this.getValue();
        if (value == null) {
            return;
        }
        this.timeBar.setValue(value.currentTime() / value.endTime() * 100.0);
        this.startTimeLabel.setText(this.dateTimeConverter.convert(value.currentTime(), DateTimeConverter.Time.Milliseconds));
        if (this.endTimeLabel.getText().length() == 0) {
            this.endTimeLabel.setText(this.dateTimeConverter.convert(value.endTime(), DateTimeConverter.Time.Milliseconds));
        }
        if (this.chapterNavigation != null) {
            this.chapterNavigation.setCurrentPlayTime((long)value.currentTime());
        }
        if (this.episodeTranscription != null) {
            this.episodeTranscription.setCurrentPlayTime((long)value.currentTime());
        }
        super.succeeded();
    }
}

