/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer.timebar;

import de.mallongigi.mediaplayer.MediaplayerKeyHandler;
import de.mallongigi.mediaplayer.audio.ChapterNavigation;
import de.mallongigi.mediaplayer.timebar.TimeBarService;
import de.mallongigi.mediaplayer.transcription.EpisodeTranscription;
import de.mallongigi.singleton.Container;
import de.mallongigi.ui.concurrent.JavaFXUtil;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.Duration;

public final class TimeBar {
    private Slider timeBar;
    private InvalidationListener timeBarValueLister;
    private final MediaView mediaView;
    private final Label startTimeLabel = new Label();
    private final Label endTimeLabel = new Label();

    public TimeBar(MediaView mediaView) {
        this.mediaView = mediaView;
    }

    public HBox create() {
        HBox box = new HBox();
        box.setAlignment(Pos.TOP_CENTER);
        this.timeBar = new Slider();
        this.startTimeLabel.setTextFill((Paint)Color.WHITE);
        this.endTimeLabel.setTextFill((Paint)Color.WHITE);
        Stage stage = Container.get(Stage.class);
        this.timeBar.prefWidthProperty().bind((ObservableValue)Bindings.selectDouble((ObservableValue)stage.sceneProperty(), (String[])new String[]{"width"}).subtract(200));
        box.getChildren().addAll((Object[])new Node[]{this.startTimeLabel, this.timeBar, this.endTimeLabel});
        return box;
    }

    public void restart(MediaplayerKeyHandler keyHandler, final Runnable runnable, ChapterNavigation chapterNavigation, EpisodeTranscription episodeTranscription) {
        this.endTimeLabel.setText("");
        this.timeBar.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)keyHandler);
        this.timeBarValueLister = new InvalidationListener(){

            public void invalidated(Observable ov) {
                if (TimeBar.this.timeBar.isPressed()) {
                    TimeBar.this.timeBar.setUserData((Object)true);
                    MediaPlayer player = TimeBar.this.mediaView.getMediaPlayer();
                    player.setStartTime(new Duration(0.0));
                    player.seek(player.getMedia().getDuration().multiply(TimeBar.this.timeBar.getValue() / 100.0));
                    TimeBar.this.timeBar.setUserData((Object)false);
                }
            }
        };
        this.timeBar.valueProperty().addListener(this.timeBarValueLister);
        final TimeBarService service = new TimeBarService(this.timeBar, this.mediaView, this.startTimeLabel, this.endTimeLabel, chapterNavigation, episodeTranscription);
        this.mediaView.getMediaPlayer().currentTimeProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable ov) {
                service.restart();
            }
        });
        Thread endOfMedia = new Thread(new Runnable(){

            @Override
            public void run() {
                String currentTime = TimeBar.this.startTimeLabel.getText();
                String endTime = TimeBar.this.endTimeLabel.getText();
                while (endTime.length() == 0 || !currentTime.equals(endTime)) {
                    try {
                        Thread.sleep(5000L);
                        currentTime = TimeBar.this.startTimeLabel.getText();
                        endTime = TimeBar.this.endTimeLabel.getText();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                JavaFXUtil.runLater(runnable);
            }
        });
        endOfMedia.start();
    }

    public void stop(MediaplayerKeyHandler keyHandler) {
        this.timeBar.removeEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)keyHandler);
        this.timeBar.valueProperty().removeListener(this.timeBarValueLister);
    }
}

