/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer.audio;

import de.mallongigi.images.ImageResult;
import de.mallongigi.images.PixelImageLoader;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.images.model.ImageModelFactory;
import de.mallongigi.images.typen.ImageResultType;
import de.mallongigi.mediaplayer.audio.AudioMediaplayerContentTypes;
import de.mallongigi.podcast.episode.model.Chapter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.singleton.Container;
import de.mallongigi.ui.elements.HTMLView;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.scene.image.Image;

public final class AudioMediaPlayerContentPane {
    private static final Logger LOG = Logger.getLogger(AudioMediaPlayerContentPane.class.getName());
    private AudioMediaplayerContentTypes currentContent = AudioMediaplayerContentTypes.IMAGES;
    private HTMLView root = new HTMLView(this.currentContent.getTemplate());
    private ImageModel currentImageModel;
    private ImageModel defaultImage;
    private Image currentImage;
    private BooleanProperty showSubtitles;

    AudioMediaPlayerContentPane(BooleanProperty showSubtitles) {
        this.showSubtitles = showSubtitles;
        this.showSubtitles.addListener((o, oldValue, newValue) -> {
            String visibility = newValue != false ? "block" : "none";
            this.root.setAttributeByElementId("image", "height", this.calcImageHeigth(this.currentImage));
            this.root.setAttributeByElementId("transcription", "style", "display:" + visibility);
        });
        this.root.heightProperty().addListener(l -> this.root.setAttributeByElementId("image", "height", this.calcImageHeigth(this.currentImage)));
    }

    HTMLView getComponent() {
        return this.root;
    }

    void showCurrentChapterImage() {
        this.setImageContent(this.currentImageModel);
    }

    void setChapter(Chapter chapter, PodcastEpisodeModel podcastEpisodeModel) {
        try {
            ImageModel model = null;
            if (chapter != null && chapter.getImageURL() != null) {
                model = Container.get(ImageModelFactory.class).create(chapter, podcastEpisodeModel);
            }
            this.defaultImage = podcastEpisodeModel.getImage() != null ? podcastEpisodeModel.getImage() : podcastEpisodeModel.getChannel().getImage();
            if (model == null) {
                model = this.defaultImage;
            }
            if (this.currentContent == AudioMediaplayerContentTypes.IMAGES) {
                this.setImageContent(model);
            } else {
                this.currentImageModel = model;
            }
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    private void setImageContent(ImageModel imageModel) {
        this.currentContent = AudioMediaplayerContentTypes.IMAGES;
        ImageResult image = new PixelImageLoader().create(imageModel);
        if (image.type() == ImageResultType.Error) {
            image = new PixelImageLoader().create(this.defaultImage);
            this.currentImageModel = this.defaultImage;
        } else {
            this.currentImageModel = imageModel;
        }
        this.currentImage = image.image();
        this.root.setTemplate(this.currentContent.getTemplate());
        this.root.setContent(this.currentImageModel.getLocation(), this.calcImageHeigth(image.image()));
    }

    private String calcImageHeigth(Image image) {
        if (this.currentImage == null || this.root.getHeight() == 0.0) {
            return "90%";
        }
        int heigth = (int)this.root.getHeight();
        heigth = this.showSubtitles.get() ? (heigth -= 200) : (heigth -= 30);
        if (heigth < 0) {
            return "30px";
        }
        return heigth + "px";
    }

    void setShownotes(StringBuffer shownotes) {
        if (shownotes == null) {
            return;
        }
        this.currentContent = AudioMediaplayerContentTypes.SHOWNOTES;
        this.root.setTemplate(this.currentContent.getTemplate());
        this.root.setContent(shownotes.toString());
    }
}

