/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer;

import de.mallongigi.errorhandling.ErrorContainer;
import de.mallongigi.mediaplayer.MediaplayerKeyHandler;
import de.mallongigi.mediaplayer.PlaySpeedSelection;
import de.mallongigi.mediaplayer.VolumeSlider;
import de.mallongigi.mediaplayer.timebar.TimeBar;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.elements.UIButton;
import de.mallongigi.views.ApplicationViewNames;
import de.mallongigi.views.ApplicationViewsModel;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.AnimationTimer;
import javafx.animation.FadeTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.stage.Stage;
import javafx.util.Duration;

public final class VideoMediaPlayer {
    private static final Logger LOG = Logger.getLogger(VideoMediaPlayer.class.getName());
    @Inject(safety=false)
    private Stage primaryStage;
    @Inject
    private OSPlatform plattform;
    @Inject
    private ApplicationViewsModel viewModel;
    @Inject
    private ErrorContainer errorContainer;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private LanguageResource languageResource;
    private long navigationTime = 0L;
    private final Group root = new Group();
    private Path mediaFile;
    private PodcastEpisodeModel podcastEpisodeMode;
    private double startDuration;
    private FadeTransition transitionFadeOut;
    private FadeTransition transitionFadeIn;
    private AnimationTimer navigationFadeOutTimer;
    private final VBox navigationWrapper = new VBox();
    private VolumeSlider volumeSlider;
    private TimeBar timeBar;
    private MediaView mediaView;
    private final UIButton playButton = new UIButton(LanguageKeys.pause, DefaultIcons.PausePlay);
    private final UIButton stopButton = new UIButton(LanguageKeys.stop, DefaultIcons.StopPlay);
    private MediaplayerKeyHandler keyHandler;

    VideoMediaPlayer() {
        Container.inject(this);
    }

    public void setPodcastEpisode(PodcastEpisodeModel model) throws Exception {
        this.podcastEpisodeMode = model;
        this.mediaFile = this.podcastEpisodeMode.getChannel().getPodcastFilenameConverter().convertEpisode(this.podcastEpisodeMode);
        this.startDuration = this.podcastEpisodeMode.getPlayerDuration();
    }

    Group getRoot() {
        return this.root;
    }

    boolean play() {
        try {
            this.plattform.disableScreenSaver();
            Media pick = new Media(this.mediaFile.toUri().toString());
            MediaPlayer player = new MediaPlayer(pick);
            player.setStartTime(new Duration(this.startDuration));
            if (this.mediaView == null) {
                this.init(player);
            } else {
                if (this.mediaView.getMediaPlayer().getStatus().equals((Object)MediaPlayer.Status.READY)) {
                    this.stopPlayer();
                }
                this.mediaView.setMediaPlayer(player);
            }
            this.restart();
            player.play();
            this.navigationTime = this.plattform.getSystemTime();
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, this.errorContainer.add(LanguageKeys.errorMessageDownloadFile, "URL Play " + this.podcastEpisodeMode.getTitle()), e);
            return false;
        }
    }

    private void init(MediaPlayer player) throws Exception {
        this.playButton.setMinWidth(100.0);
        this.mediaView = new MediaView(player);
        this.volumeSlider = new VolumeSlider(this.mediaView);
        this.timeBar = new TimeBar(this.mediaView);
        this.navigationWrapper.setUserData((Object)false);
        this.navigationWrapper.setStyle("-fx-background-color: rgba(0, 0, 0, .7)");
        HBox navigation = new HBox();
        navigation.setSpacing(30.0);
        navigation.setAlignment(Pos.TOP_CENTER);
        this.root.getParent().setStyle("-fx-background-color: rgba(0, 0, 0, 1)");
        navigation.getChildren().addAll((Object[])new Node[]{this.playButton, this.stopButton, this.volumeSlider.create(), new PlaySpeedSelection(this.mediaView).create()});
        this.navigationWrapper.getChildren().addAll((Object[])new Node[]{this.timeBar.create(), navigation});
        final Group videoContentView = new Group(new Node[]{this.mediaView});
        this.root.getChildren().addAll((Object[])new Node[]{videoContentView, this.navigationWrapper});
        this.navigationWrapper.layoutXProperty().set(10.0);
        DoubleProperty mvw = this.mediaView.fitWidthProperty();
        DoubleProperty mvh = this.mediaView.fitHeightProperty();
        mvw.bind((ObservableValue)Bindings.selectDouble((ObservableValue)this.mediaView.sceneProperty(), (String[])new String[]{"width"}));
        mvh.bind((ObservableValue)Bindings.selectDouble((ObservableValue)this.mediaView.sceneProperty(), (String[])new String[]{"height"}));
        this.navigationWrapper.layoutYProperty().bind((ObservableValue)Bindings.selectDouble((ObservableValue)this.mediaView.sceneProperty(), (String[])new String[]{"height"}).subtract(80));
        this.root.getScene().widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                VideoMediaPlayer.this.navigationWrapper.setPrefWidth(arg2.doubleValue() - 20.0);
                double sceneWidth = arg2.doubleValue();
                videoContentView.setLayoutX((sceneWidth - videoContentView.prefWidth(-1.0)) / 2.0);
            }
        });
        this.root.setOnMouseMoved(e -> {
            if (!this.navigationWrapper.isManaged()) {
                this.root.setCursor(Cursor.DEFAULT);
                this.navigationWrapper.setManaged(true);
                this.navigationWrapper.setVisible(true);
                this.navigationTime = this.plattform.getSystemTime();
                this.transitionFadeIn = new FadeTransition(Duration.millis((double)500.0), (Node)this.navigationWrapper);
                this.transitionFadeIn.setFromValue(0.0);
                this.transitionFadeIn.setToValue(1.0);
                this.transitionFadeIn.play();
            }
        });
        this.root.setOnMouseClicked(e -> {
            if (e.getButton().equals((Object)MouseButton.PRIMARY) && e.getClickCount() == 2) {
                if (this.primaryStage.isFullScreen()) {
                    this.primaryStage.setFullScreen(false);
                } else {
                    this.primaryStage.setFullScreen(true);
                    this.root.setUserData((Object)true);
                }
            }
        });
        this.navigationWrapper.setOnMouseEntered(e -> this.navigationWrapper.setUserData((Object)true));
        this.navigationWrapper.setOnMouseExited(e -> this.navigationWrapper.setUserData((Object)false));
        this.navigationFadeOutTimer = new AnimationTimer(){

            public void handle(long timestamp) {
                Boolean mouseState;
                if (VideoMediaPlayer.this.plattform.getSystemTime() - VideoMediaPlayer.this.navigationTime > 10000L && !(mouseState = (Boolean)VideoMediaPlayer.this.navigationWrapper.getUserData()).booleanValue()) {
                    VideoMediaPlayer.this.navigationTime = VideoMediaPlayer.this.plattform.getSystemTime();
                    VideoMediaPlayer.this.transitionFadeOut = new FadeTransition(Duration.millis((double)1000.0), (Node)VideoMediaPlayer.this.navigationWrapper);
                    VideoMediaPlayer.this.transitionFadeOut.setFromValue(1.0);
                    VideoMediaPlayer.this.transitionFadeOut.setToValue(0.0);
                    VideoMediaPlayer.this.transitionFadeOut.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent arg0) {
                            VideoMediaPlayer.this.navigationWrapper.setManaged(false);
                            if (VideoMediaPlayer.this.primaryStage.isFullScreen()) {
                                VideoMediaPlayer.this.root.setCursor(Cursor.NONE);
                            }
                            videoContentView.setLayoutX((VideoMediaPlayer.this.root.getScene().getWidth() - videoContentView.prefWidth(-1.0)) / 2.0);
                        }
                    });
                    VideoMediaPlayer.this.transitionFadeOut.play();
                }
            }
        };
        this.mediaView.getMediaPlayer().setOnPaused(new Runnable(){

            @Override
            public void run() {
                VideoMediaPlayer.this.playButton.setText(VideoMediaPlayer.this.languageResource.messageForKey(LanguageKeys.play));
                VideoMediaPlayer.this.playButton.setGraphic(VideoMediaPlayer.this.iconFactory.create(DefaultIcons.StartPlay));
            }
        });
        this.mediaView.getMediaPlayer().setOnPlaying(new Runnable(){

            @Override
            public void run() {
                VideoMediaPlayer.this.playButton.setText(VideoMediaPlayer.this.languageResource.messageForKey(LanguageKeys.pause));
                VideoMediaPlayer.this.playButton.setGraphic(VideoMediaPlayer.this.iconFactory.create(DefaultIcons.PausePlay));
            }
        });
        this.keyHandler = new MediaplayerKeyHandler(this.mediaView.getMediaPlayer(), this.volumeSlider, () -> this.stopPlayer());
        this.mediaView.getMediaPlayer().setOnReady(new Runnable(){

            @Override
            public void run() {
                videoContentView.setLayoutX((VideoMediaPlayer.this.root.getScene().getWidth() - videoContentView.prefWidth(-1.0)) / 2.0);
            }
        });
    }

    private void restart() {
        this.primaryStage.setTitle(this.podcastEpisodeMode.getTitle());
        this.root.setUserData((Object)false);
        this.keyHandler.setPlayer(this.mediaView.getMediaPlayer());
        this.navigationFadeOutTimer.start();
        this.playButton.setOnAction(e -> {
            MediaPlayer player = this.mediaView.getMediaPlayer();
            if (player.getStatus().equals((Object)MediaPlayer.Status.PLAYING)) {
                player.pause();
            } else {
                player.play();
            }
        });
        this.stopButton.setOnAction(e -> this.stopPlayer());
        this.mediaView.getMediaPlayer().setOnEndOfMedia(() -> {
            this.navigationFadeOutTimer.stop();
            this.navigationWrapper.setManaged(true);
            this.navigationWrapper.setVisible(true);
            this.transitionFadeIn = new FadeTransition(Duration.millis((double)1.0), (Node)this.navigationWrapper);
            this.transitionFadeIn.setFromValue(0.0);
            this.transitionFadeIn.setToValue(1.0);
            this.transitionFadeIn.play();
            this.root.setCursor(Cursor.DEFAULT);
            if (this.primaryStage.isFullScreen()) {
                this.primaryStage.setFullScreen(false);
            }
            this.podcastEpisodeMode.setPlayerDuration(0.0);
        });
        this.volumeSlider.reset();
        this.timeBar.restart(this.keyHandler, () -> this.stopPlayer(), null, null);
    }

    private void stopPlayer() {
        if (!((Boolean)this.root.getUserData()).booleanValue()) {
            this.root.setCursor(Cursor.DEFAULT);
        } else {
            this.root.setUserData((Object)false);
        }
        this.keyHandler.removePlayer();
        this.plattform.resetScreenSaverState();
        this.primaryStage.setTitle("Mallongigi");
        if (this.mediaView.getMediaPlayer().getStatus() != MediaPlayer.Status.PLAYING && this.mediaView.getMediaPlayer().getStatus() != MediaPlayer.Status.PAUSED) {
            return;
        }
        if (this.mediaView.getMediaPlayer().getCurrentTime().toMillis() != this.mediaView.getMediaPlayer().getTotalDuration().toMillis()) {
            this.podcastEpisodeMode.setPlayerDuration(this.mediaView.getMediaPlayer().getCurrentTime().toMillis());
        }
        this.mediaView.getMediaPlayer().stop();
        if (this.transitionFadeIn != null) {
            this.transitionFadeIn.stop();
        }
        if (this.transitionFadeOut != null) {
            this.transitionFadeOut.stop();
        }
        this.navigationFadeOutTimer.stop();
        if (this.primaryStage.isFullScreen()) {
            this.primaryStage.setFullScreen(false);
        }
        this.viewModel.setView(ApplicationViewNames.Podcasts);
        this.viewModel.clearPlayer();
        this.viewModel.disableView(ApplicationViewNames.Mediaplayer, true);
        this.mediaView.getMediaPlayer().dispose();
        this.timeBar.stop(this.keyHandler);
        this.volumeSlider.stop();
    }

    void stop() {
        if (this.mediaView == null) {
            return;
        }
        MediaPlayer player = this.mediaView.getMediaPlayer();
        if (player.getStatus() == MediaPlayer.Status.PLAYING) {
            this.mediaView.getMediaPlayer().stop();
        }
    }

    public boolean isPlaying(PodcastEpisodeModel item) {
        return this.podcastEpisodeMode != null && this.podcastEpisodeMode.equals(item);
    }
}

