/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer;

import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.GridPane;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.util.Duration;

public final class PlaySpeedSelection {
    @Inject
    private IconFactory iconFactory;
    private final MediaView mediaView;

    public PlaySpeedSelection(MediaView mediaView) {
        Container.inject(this);
        this.mediaView = mediaView;
    }

    public GridPane create() {
        GridPane root = new GridPane();
        root.setAlignment(Pos.TOP_CENTER);
        root.setHgap(5.0);
        final ComboBox selectionBox = new ComboBox();
        selectionBox.getItems().addAll((Object[])new Double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5});
        SingleSelectionModel selectionModel = selectionBox.getSelectionModel();
        selectionModel.select(0);
        selectionBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                MediaPlayer player = PlaySpeedSelection.this.mediaView.getMediaPlayer();
                double duration = player.getCurrentTime().toMillis();
                Double value = (Double)selectionBox.getValue();
                player.pause();
                player.setRate(value.doubleValue());
                player.seek(new Duration(duration));
                player.play();
            }
        });
        root.add(this.iconFactory.create(DefaultIcons.speed), 0, 0);
        root.add((Node)selectionBox, 1, 0);
        return root;
    }
}

