/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.images.model;

import de.mallongigi.file.FileUtil;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.images.typen.DeviceType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.model.Chapter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.resource.images.DefaultImages;
import de.mallongigi.singleton.Singleton;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

@Singleton(makeAutoInstance=false)
public final class ImageModelFactory {
    private static final Logger LOG = Logger.getLogger(ImageModelFactory.class.getName());

    private ImageModelFactory() {
    }

    public ImageModel create(PodcastChannelModel model) {
        try {
            Path imageFile = model.getPodcastFilenameConverter().convertImages(model);
            ImageModel image = new ImageModel(imageFile.toString(), DeviceType.File);
            return image;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cant Load Channel '" + model.getTitle() + "' Image from URL : " + model.getImageURL(), e);
            return new ImageModel(DefaultImages.RSS.getLocation(), DeviceType.Package);
        }
    }

    public ImageModel create(PodcastEpisodeModel model) {
        try {
            String url = model.getImageURL();
            if (url == null || url.isBlank()) {
                return this.create(model.getChannel());
            }
            Path imageFile = model.getChannel().getPodcastFilenameConverter().convertImages(model);
            ImageModel image = new ImageModel(imageFile.toString(), DeviceType.File);
            return image;
        }
        catch (Exception e) {
            return new ImageModel(DefaultImages.RSS);
        }
    }

    public ImageModel create(Chapter chapter, PodcastEpisodeModel podcastEpisodeModel) throws IOException {
        return new ImageModel(FileUtil.getPodcastLocaleChapterImageFile(chapter, podcastEpisodeModel).toFile().getAbsolutePath(), DeviceType.File);
    }

    public ImageModel create(DefaultImages defaultImages) {
        return new ImageModel(defaultImages);
    }
}

