/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.images.elements;

import de.mallongigi.images.ImageResult;
import de.mallongigi.images.PixelImageLoader;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.images.typen.ImageResultType;
import de.mallongigi.resource.images.DefaultImages;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public final class UIImageView
extends ImageView {
    private final ObjectProperty<Image> image = new SimpleObjectProperty();
    private final PixelImageLoader imageLoader = new PixelImageLoader();
    private ImageResult imageResult;

    private UIImageView() {
        this.setPreserveRatio(true);
        this.setSmooth(true);
        this.setCache(true);
        this.imageProperty().bind(this.image);
    }

    public void setImage(ImageResult imageResult) {
        this.image.set((Object)imageResult.image());
    }

    UIImageView(final ImageModel imageModel, final int size) {
        this();
        if (imageModel == null) {
            this.imageResult = new PixelImageLoader().create(DefaultImages.RSS, size);
            this.image.set((Object)this.imageResult.image());
        } else {
            this.imageResult = this.imageLoader.create(imageModel, size);
            this.image.set((Object)this.imageResult.image());
            imageModel.addLocationListener(new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                    Image i = UIImageView.this.imageLoader.create(imageModel, size).image();
                    UIImageView.this.image.set((Object)i);
                }
            });
        }
    }

    ImageResultType getImageResultType() {
        if (this.imageResult == null) {
            return null;
        }
        return this.imageResult.type();
    }
}

