/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.images.elements;

import de.mallongigi.images.ImageResult;
import de.mallongigi.images.PixelImageLoader;
import de.mallongigi.images.SVGLoader;
import de.mallongigi.images.elements.UIImageView;
import de.mallongigi.images.model.ImageIconModel;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.images.typen.ImageResultType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.resource.icons.IconColors;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.images.DefaultImages;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.ui.style.Styles;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

@Singleton
public final class UIImageFactory {
    @Inject
    private Styles styles;
    @Inject
    private IconFactory iconFactory;

    private UIImageFactory() {
    }

    public Node create(PodcastChannelModel pcm, int size) {
        ImageModel model = pcm.getImage();
        if (model == null) {
            return new ImageView(new PixelImageLoader().create(DefaultImages.RSS, size).image());
        }
        if (model.getLocation().endsWith(".svg")) {
            return new SVGLoader().get(model.getLocation(), size, IconColors.Default);
        }
        UIImageView image = new UIImageView(model, size);
        if (image.getImageResultType() != ImageResultType.Orgiginal) {
            Container.get(ProgressPool.class).addImageDownload(model, pcm);
        }
        return image;
    }

    public Node create(PodcastEpisodeModel pem, int size) {
        ImageModel model = pem.getImage();
        if (model == null) {
            return new ImageView(new PixelImageLoader().create(DefaultImages.RSS, size).image());
        }
        if (model.getLocation().endsWith(".svg")) {
            return new SVGLoader().get(model.getLocation(), size, IconColors.Default);
        }
        UIImageView image = new UIImageView(model, size);
        if (image.getImageResultType() == ImageResultType.Alternativ) {
            Container.get(ProgressPool.class).addImageDownload(model, pem);
            ImageResult imageResult = new PixelImageLoader().create(pem.getChannel().getImage(), size);
            image.setImage(imageResult);
        }
        return image;
    }

    public Node create(ImageModel model, int size) {
        if (model.getLocation().endsWith(".svg")) {
            return new SVGLoader().get(model.getLocation(), size, IconColors.Default);
        }
        return new UIImageView(model, size);
    }

    public Group create(ImageIconModel model, int size) {
        Node icon = this.iconFactory.create(model.getImageIcon(), size / 2, IconColors.Focus);
        UIImageView image = new UIImageView(model, size);
        HBox wrapper = new HBox();
        wrapper.getChildren().add((Object)icon);
        BackgroundFill backgroundFill = new BackgroundFill((Paint)Color.BLACK, null, null);
        Background background = new Background(new BackgroundFill[]{backgroundFill});
        wrapper.setBackground(background);
        wrapper.setLayoutX((double)(size / 2));
        wrapper.setLayoutY((double)(size / 2));
        Group result = new Group();
        result.getChildren().addAll((Object[])new Node[]{image, wrapper});
        return result;
    }
}

