/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.images;

import de.mallongigi.file.FileUtil;
import de.mallongigi.http.HttpParameters;
import de.mallongigi.images.ImageContainer;
import de.mallongigi.images.ImageResult;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.images.typen.ImageResultType;
import de.mallongigi.podcast.episode.model.Chapter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.resource.images.DefaultImages;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.image.Image;

public final class PixelImageLoader {
    private static final Logger LOG = Logger.getLogger(PixelImageLoader.class.getName());
    @Inject
    private ImageContainer imageContainer;

    public PixelImageLoader() {
        Container.inject(this);
    }

    public ImageResult create(ImageModel imageModel) {
        if (imageModel == null) {
            return this.create(DefaultImages.RSS, 40, ImageResultType.Error);
        }
        switch (imageModel.getDeviceType()) {
            case Remote: 
            case File: {
                File file = new File(imageModel.getLocation());
                if (!file.exists()) {
                    return null;
                }
                URI uri = file.toURI();
                Image image = new Image(uri.toString());
                return new ImageResult(image, ImageResultType.Orgiginal);
            }
            case Package: {
                return new ImageResult(new Image(this.getClass().getResourceAsStream(imageModel.getLocation())), ImageResultType.Orgiginal);
            }
        }
        return this.create(DefaultImages.RSS, 40, ImageResultType.Alternativ);
    }

    public ImageResult create(ImageModel imageModel, int size) {
        if (imageModel == null) {
            return this.create(DefaultImages.RSS, size, ImageResultType.Error);
        }
        switch (imageModel.getDeviceType()) {
            case Remote: 
            case File: {
                String location = imageModel.getLocation();
                Image image = this.imageContainer.get(location, size);
                if (image != null) {
                    return new ImageResult(image, ImageResultType.Orgiginal);
                }
                Path file = Paths.get(location, new String[0]);
                if (Files.notExists(file, new LinkOption[0])) {
                    return this.create(DefaultImages.RSS, size, ImageResultType.Alternativ);
                }
                URI uri = file.toUri();
                image = new Image(uri.toString(), (double)size, (double)size, false, false);
                this.imageContainer.add(location, size, image);
                return new ImageResult(image, ImageResultType.Orgiginal);
            }
            case Package: {
                return new ImageResult(new Image(this.getClass().getResourceAsStream(imageModel.getLocation()), (double)size, (double)size, false, false), ImageResultType.Orgiginal);
            }
        }
        return this.create(DefaultImages.RSS, size, ImageResultType.Alternativ);
    }

    public ImageResult download(String imageUrl, int size) {
        try {
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(new URI(imageUrl)).header(HttpParameters.USER_AGENT.value(), "Mallongigi Podcatcher").version(HttpClient.Version.HTTP_1_1).GET().timeout(Duration.ofMinutes(1L));
            HttpRequest request = requestBuilder.build();
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() >= 400) {
                return this.create(DefaultImages.RSS, size, ImageResultType.Error);
            }
            return new ImageResult(new Image(response.body(), (double)size, (double)size, false, false), ImageResultType.Orgiginal);
        }
        catch (Exception e) {
            return this.create(DefaultImages.RSS, size, ImageResultType.Error);
        }
    }

    public boolean download(Chapter chapter, PodcastEpisodeModel episode) {
        try {
            HttpRequest.Builder requestBuilder;
            HttpRequest request;
            Path imageFile = FileUtil.getPodcastLocaleChapterImageFile(chapter, episode);
            if (imageFile == null) {
                return false;
            }
            if (imageFile.toFile().exists()) {
                return true;
            }
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpResponse<InputStream> response = client.send(request = (requestBuilder = HttpRequest.newBuilder().uri(new URI(chapter.getImageURL())).header(HttpParameters.USER_AGENT.value(), "Mallongigi Podcatcher").version(HttpClient.Version.HTTP_1_1).GET().timeout(Duration.ofMinutes(1L))).build(), HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() >= 400) {
                return false;
            }
            Files.copy(response.body(), imageFile, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public ImageResult create(DefaultImages defaultImage, int size) {
        return this.create(defaultImage, size, ImageResultType.Orgiginal);
    }

    private ImageResult create(DefaultImages defaultImage, int size, ImageResultType type) {
        return new ImageResult(new Image(this.getClass().getResourceAsStream(defaultImage.getLocation()), (double)size, (double)size, false, false), type);
    }
}

