/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http.feed.ard;

import de.mallongigi.http.feed.FeedContent;
import de.mallongigi.http.feed.PodcastChannelParser;
import de.mallongigi.podcast.channel.model.PodcastChannelFeedType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ARDParser
implements PodcastChannelParser {
    private static final Logger LOG = Logger.getLogger(ARDParser.class.getName());
    private final boolean markAsNew;

    public ARDParser(boolean markAsNew) {
        this.markAsNew = markAsNew;
    }

    @Override
    public PodcastChannelModel parse(FeedContent connection) throws Exception {
        try {
            PodcastChannelModel pcm = new PodcastChannelModel();
            pcm.setFeedType(PodcastChannelFeedType.Audiothek);
            pcm.setPodcastFeedUrl(connection.getURL());
            connection.connect();
            pcm.setCachHash(connection.getCashHash());
            pcm.setErrorMessage(connection.getConnectionError());
            if (!connection.hasContent()) {
                return pcm;
            }
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(connection.getContent()));
            JsonObject object = jsonReader.readObject();
            JsonObject datas = object.getJsonObject("data");
            JsonObject programSet = datas.getJsonObject("programSet");
            JsonArray items = programSet.getJsonObject("items").getJsonArray("edges");
            this.parseChannel(programSet, pcm);
            this.parseEpisode(items, pcm);
            return pcm;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            throw e;
        }
    }

    private void parseEpisode(JsonArray items, PodcastChannelModel pcm) throws IOException {
        items.forEach(o -> {
            try {
                PodcastEpisodeModel episode = new PodcastEpisodeModel();
                episode.getState().setNew(this.markAsNew);
                JsonObject item = ((JsonObject)o).getJsonObject("node");
                episode.setChannel(pcm);
                episode.setDuration(item.getJsonNumber("duration").bigDecimalValue());
                episode.setId(item.getString("id"));
                String date = item.getString("publicationStartDateAndTime");
                episode.setDate(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX", Locale.US).parse(date));
                if (!item.isNull("synopsis")) {
                    episode.setDescription(item.getString("synopsis"));
                }
                episode.setTitle(item.getString("title"));
                JsonObject image = item.getJsonObject("image");
                episode.setImageURL(image.getString("url").replaceAll("\\{width\\}", "200"));
                String downloadUrl = this.getDownloadUrl(item.getJsonArray("audios"));
                if (downloadUrl != null) {
                    episode.setUrl(downloadUrl);
                    pcm.add(episode);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Fehler beim Parsen der Episode : " + o.toString(), e);
            }
        });
    }

    private String getDownloadUrl(JsonArray array) {
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            JsonObject v = array.getJsonObject(i);
            for (String key : new String[]{"downloadUrl", "url"}) {
                String url = v.getString(key, null);
                if (url == null) continue;
                return url;
            }
        }
        return null;
    }

    private void parseChannel(JsonObject channelInfos, PodcastChannelModel pcm) throws IOException {
        pcm.setTitle(channelInfos.getString("title"));
        pcm.setDescription(channelInfos.getString("synopsis"));
        pcm.setHomepage(channelInfos.getString("sharingUrl"));
        JsonObject image = channelInfos.getJsonObject("image");
        String imageString = image.getString("url");
        pcm.setImageURL(imageString.replaceAll("\\{width\\}", "200"));
    }
}

