/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http.feed.ard;

import de.mallongigi.http.HttpParameters;
import de.mallongigi.http.feed.PodcastChannelParser;
import de.mallongigi.http.feed.PodcastFeedConnectionConfig;
import de.mallongigi.http.feed.ard.ARDParser;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.stream.Collectors;

public final class ARDAudiothekConnectionConfig
implements PodcastFeedConnectionConfig {
    @Override
    public PodcastChannelParser getPodcastChannelParser(boolean markAsNew) {
        return new ARDParser(markAsNew);
    }

    @Override
    public HttpRequest createHttpRequest(PodcastChannelModel model) throws Exception {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create("https://api.ardaudiothek.de/graphql")).header(HttpParameters.USER_AGENT.value(), "Mallongigi Podcatcher").header(HttpParameters.ACCEPT_ENCODING.value(), "gzip, deflate").header(HttpParameters.ACCEPT_CONTENT_TYPE.value(), "application/json").header("Content-Type", "application/json").version(HttpClient.Version.HTTP_1_1).POST(HttpRequest.BodyPublishers.ofString(this.getRequestContent(model.getPodcastFeedUrl()))).timeout(Duration.ofMinutes(1L));
        return requestBuilder.build();
    }

    private String getRequestContent(String url) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/de/mallongigi/http/ardAudiothekRequest.graphql")));
        String content = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        String[] parts = url.split("/");
        String id = parts[parts.length - 1];
        String result = content.replaceAll("\\{id\\}", id);
        result = result.replaceAll("\n", "");
        result = result.replaceAll("\r", "");
        result = result.replaceAll("\t", " ");
        return result;
    }
}

