/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http.feed;

import de.mallongigi.http.feed.FeedURLConnector;
import de.mallongigi.http.feed.PodcastEpisodeSynchronizer;
import de.mallongigi.http.feed.PodcastFeedConfigFactory;
import de.mallongigi.http.feed.PodcastFeedConnectionConfig;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.images.model.ImageModelFactory;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.channel.model.NewPodcastChannelHelper;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.RefreshPodcastChannelModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class RefreshPodcastChannelClient {
    private static final Logger LOG = Logger.getLogger(RefreshPodcastChannelClient.class.getName());
    @Inject
    private OSPlatform plattform;
    @Inject
    private ProgressPool progressPool;
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private ApplicationSettings settings;
    @Inject
    private ImageModelFactory imageModelFactory;
    private static final long MINIMUM_REFRESH_TIME = 60000L;

    public RefreshPodcastChannelClient() {
        Container.inject(this);
    }

    public RefreshPodcastChannelModel refresh(PodcastChannelModel channel) throws Exception {
        channel.setLastRefresh(this.plattform.getSystemTime());
        PodcastFeedConnectionConfig config = new PodcastFeedConfigFactory().getConfig(channel);
        PodcastChannelModel newModel = config.getPodcastChannelParser(true).parse(new FeedURLConnector(channel, config));
        newModel.setId(channel.getId());
        if (channel.getImage() != null && !new File(channel.getImage().getLocation()).exists()) {
            ImageModel image = this.imageModelFactory.create(channel);
            channel.setImage(image);
        }
        if (newModel.getCachHash() != null && channel.getCachHash() != null && !newModel.getCachHash().isBlank() && !channel.getCachHash().isBlank() && RefreshPodcastChannelClient.equals(newModel.getCachHash(), channel.getCachHash())) {
            return null;
        }
        if (newModel.getEpisodes().isEmpty()) {
            this.hasError(newModel, channel);
            throw new Exception((String)newModel.errorProperty().get());
        }
        new NewPodcastChannelHelper().makePodcastDir(newModel);
        if (this.hasError(newModel, channel)) {
            throw new Exception((String)newModel.errorProperty().get());
        }
        RefreshPodcastChannelModel refreshModel = new RefreshPodcastChannelModel(channel, newModel);
        if (!RefreshPodcastChannelClient.equals(newModel.getImageURL(), channel.getImageURL())) {
            ImageModel image = this.imageModelFactory.create(newModel);
            newModel.setImage(image);
            return refreshModel;
        }
        if (!RefreshPodcastChannelClient.equals(newModel.getDescription(), channel.getDescription())) {
            return refreshModel;
        }
        if (!RefreshPodcastChannelClient.equals(newModel.getTitle(), channel.getTitle())) {
            return refreshModel;
        }
        if (!RefreshPodcastChannelClient.equals(newModel.getPodcastFeedUrl(), channel.getPodcastFeedUrl())) {
            return refreshModel;
        }
        List<PodcastEpisodeModel> newList = newModel.getEpisodes();
        List<PodcastEpisodeModel> currentList = channel.getEpisodes();
        for (PodcastEpisodeModel ne : newList) {
            boolean isNew = true;
            for (PodcastEpisodeModel e : currentList) {
                if (!ne.equals(e)) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            return refreshModel;
        }
        return null;
    }

    private boolean hasError(PodcastChannelModel newModel, PodcastChannelModel currentChannelModel) {
        if (newModel.hasErrorMessage()) {
            if (currentChannelModel != null) {
                currentChannelModel.setErrorMessage((String)newModel.errorProperty().get());
            }
            return true;
        }
        return false;
    }

    public void progressAddEpisodes(RefreshPodcastChannelModel channel) {
        PodcastChannelModel currentPodcastModel = channel.currentPodcastChannelModel();
        PodcastChannelModel newPodcastModel = channel.newPodcastChannelModel();
        if (!RefreshPodcastChannelClient.equals(newPodcastModel.getImageURL(), currentPodcastModel.getImageURL())) {
            try {
                new URI(newPodcastModel.getImageURL()).toURL();
                currentPodcastModel.setImage(newPodcastModel.getImage());
                currentPodcastModel.setImageURL(newPodcastModel.getImageURL());
            }
            catch (Exception e) {
                LOG.info(String.format("Channel Image URL %s is not valid.", newPodcastModel.getImageURL()));
            }
        }
        if (!RefreshPodcastChannelClient.equals(newPodcastModel.getDescription(), currentPodcastModel.getDescription())) {
            currentPodcastModel.setDescription(newPodcastModel.getDescription());
        }
        if (!RefreshPodcastChannelClient.equals(newPodcastModel.getTitle(), currentPodcastModel.getTitle())) {
            currentPodcastModel.setTitle(newPodcastModel.getTitle());
        }
        if (!RefreshPodcastChannelClient.equals(newPodcastModel.getPodcastFeedUrl(), currentPodcastModel.getPodcastFeedUrl())) {
            currentPodcastModel.setPodcastFeedUrl(newPodcastModel.getPodcastFeedUrl());
        }
        currentPodcastModel.setCachHash(newPodcastModel.getCachHash());
        PodcastEpisodeSynchronizer poeSynchronizer = new PodcastEpisodeSynchronizer();
        ArrayList<PodcastEpisodeModel> result = new ArrayList<PodcastEpisodeModel>();
        for (PodcastEpisodeModel ne : newPodcastModel.getEpisodes()) {
            boolean isNew = true;
            for (PodcastEpisodeModel e : currentPodcastModel.getEpisodes()) {
                if (!ne.equals(e)) continue;
                isNew = false;
                poeSynchronizer.synchronizeEpisode(e, ne);
                break;
            }
            if (!isNew) continue;
            ne.setChannel(currentPodcastModel);
            ImageModel image = this.imageModelFactory.create(ne);
            ne.setImage(image);
            if (ne.isOutOfDate() || !channel.currentPodcastChannelModel().isAutomaticDownload()) {
                ne.setCurrentDownload(false);
            } else {
                ne.setCurrentDownload(true);
            }
            currentPodcastModel.add(ne);
            if (!ne.isOutOfDate() && channel.currentPodcastChannelModel().isAutomaticDownload()) {
                this.progressPool.add(ne, ProgressAction.download);
            }
            result.add(ne);
        }
        if (!result.isEmpty()) {
            this.podcastChannelContainer.addToNavigationView(result);
        }
        currentPodcastModel.clearErrorMessage();
    }

    private static boolean equals(String newValue, String currentValue) {
        if (newValue == null && currentValue == null) {
            return true;
        }
        if (newValue == null || currentValue == null) {
            return false;
        }
        return newValue.equals(currentValue);
    }

    public boolean isOld(PodcastChannelModel channel) {
        return this.plattform.getSystemTime() - channel.getLastRefresh() > 60000L;
    }
}

