/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http.feed;

import de.mallongigi.http.feed.PodcastFeedConnectionConfig;
import de.mallongigi.http.feed.ard.ARDAudiothekConnectionConfig;
import de.mallongigi.http.feed.ard.ARDAudiothekConverter;
import de.mallongigi.http.feed.rss.RSSFeedPodcastConnectionConfig;
import de.mallongigi.podcast.channel.model.PodcastChannelFeedType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.search.itunes.ITunesURLConverter;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;

public final class PodcastFeedConfigFactory {
    @Inject
    private LanguageResource languageResource;

    public PodcastFeedConfigFactory() {
        Container.inject(this);
    }

    public PodcastFeedConnectionConfig getConfig(PodcastChannelModel model) {
        String iTunesUrl;
        PodcastChannelFeedType type = model.getFeedType();
        if (type != null) {
            if (type == PodcastChannelFeedType.Audiothek) {
                return new ARDAudiothekConnectionConfig();
            }
            return new RSSFeedPodcastConnectionConfig();
        }
        String url = model.getPodcastFeedUrl();
        if (url.indexOf("podcasts.apple.com") != -1 && (iTunesUrl = new ITunesURLConverter().convert(url)) != null) {
            url = iTunesUrl;
            model.setPodcastFeedUrl(iTunesUrl);
            return new RSSFeedPodcastConnectionConfig();
        }
        if (url.indexOf("ardaudiothek.de") != -1) {
            String audiothekUrl = new ARDAudiothekConverter().convert(url);
            if (audiothekUrl != null) {
                url = audiothekUrl;
                model.setPodcastFeedUrl(url);
                return new ARDAudiothekConnectionConfig();
            }
            model.setErrorMessage(this.languageResource.messageForKey(LanguageKeys.ardAudiothekUrlFormatError, url));
        }
        return new RSSFeedPodcastConnectionConfig();
    }
}

