/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.http.feed;

import de.mallongigi.mediaplayer.transcription.TranscriptionsLocations;
import de.mallongigi.podcast.episode.model.Chapter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;

final class PodcastEpisodeSynchronizer {
    PodcastEpisodeSynchronizer() {
    }

    void synchronizeEpisode(PodcastEpisodeModel currentEpisode, PodcastEpisodeModel newEpisode) {
        if (!this.equals(currentEpisode.getDescription(), newEpisode.getDescription())) {
            currentEpisode.setDescription(newEpisode.getDescription());
        }
        if (newEpisode.hasChapters() && !currentEpisode.hasChapters()) {
            for (Chapter c : newEpisode.getChapters()) {
                currentEpisode.addChapter(c);
            }
        }
        if (newEpisode.hasTranscriptions() && !currentEpisode.hasTranscriptions()) {
            for (TranscriptionsLocations tl : newEpisode.getTranscriptions()) {
                currentEpisode.addTranscription(tl);
            }
        }
        if (!this.equals(currentEpisode.getDuration(), newEpisode.getDuration())) {
            currentEpisode.setDuration(newEpisode.getDuration());
        }
        if (!this.equals(currentEpisode.getLink(), newEpisode.getLink())) {
            currentEpisode.setLink(newEpisode.getLink());
        }
        if (!this.equals(currentEpisode.getSubtitle(), newEpisode.getSubtitle())) {
            currentEpisode.setSubtitle(newEpisode.getSubtitle());
        }
    }

    private boolean equals(String c, String n) {
        if (n == null) {
            return true;
        }
        if (c == null && n != null) {
            return false;
        }
        return c.equals(n);
    }
}

