/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.file;

import de.mallongigi.file.FileUtil;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class PodcastFilenameConverter {
    public Path convertEpisode(PodcastEpisodeModel episode) throws IOException {
        String fileName = FileUtil.getFileNameFromUrl(episode.getUrl(), "mp3");
        Path downloadDir = FileUtil.getPodcastLocaleDownloadDirectory(episode.getChannel());
        Object nfn = null;
        int dotPos = fileName.lastIndexOf(".");
        int id = Math.abs(episode.getId().hashCode());
        if (dotPos > -1) {
            nfn = fileName.substring(0, dotPos);
            String type = fileName.substring(dotPos, fileName.length());
            nfn = (String)nfn + "_" + id + type;
        } else {
            nfn = fileName + "_" + id;
        }
        if (((String)nfn).length() > 255) {
            nfn = episode.getId();
        }
        if (((String)nfn).indexOf(".") == -1) {
            nfn = (String)nfn + "." + FileUtil.getFileFormat(episode.getUrl());
        }
        Path file = Paths.get(downloadDir.toString(), new String[]{nfn});
        return file;
    }

    public Path convertImages(PodcastEpisodeModel episode) {
        String fileName = FileUtil.getFileNameFromUrl(episode.getImageURL(), "png");
        Path directory = Paths.get(episode.getChannel().getLocaleDirectory(), fileName);
        return directory;
    }

    public Path convertImages(PodcastChannelModel channel) {
        String fileName = FileUtil.getFileNameFromUrl(channel.getImageURL(), "png");
        Path directory = Paths.get(channel.getLocaleDirectory(), fileName);
        return directory;
    }

    public Path convertToClearMP3Filename(PodcastEpisodeModel episode) throws IOException {
        Path filename = this.convertEpisode(episode);
        String type = FileUtil.getFileFormat(episode.getUrl());
        String result = filename.toString().replaceAll("." + type, "_clean.mp3");
        return Paths.get(result, new String[0]);
    }

    public Path convertToMP3File(PodcastEpisodeModel episode) throws IOException {
        Path filename = this.convertEpisode(episode);
        if (episode.isMP3Format()) {
            return filename;
        }
        String type = FileUtil.getFileFormat(episode.getUrl());
        String result = filename.toString().replaceAll("." + type, ".mp3");
        return Paths.get(result, new String[0]);
    }

    public String getAlias(PodcastEpisodeModel episode) throws Exception {
        String filename = episode.getFilename();
        String title = episode.getTitle();
        String type = filename.substring(filename.lastIndexOf("."), filename.length());
        title = title.replaceAll("\\W", "_");
        return title + type;
    }
}

