/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ffmpeg;

import de.mallongigi.ffmpeg.FFMPEGCommand;
import de.mallongigi.ffmpeg.FFMPEGTools;
import de.mallongigi.singleton.Container;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FFProbeMediaInfo {
    private static final Logger LOG = Logger.getLogger(FFProbeMediaInfo.class.getName());

    public FFProbeMediaInfo() {
        Container.inject(this);
    }

    public String getDuration(Path inputFile) {
        try {
            String line;
            FFMPEGCommand command = new FFMPEGCommand(FFMPEGTools.ffprobe);
            if (!command.isFFMPEGAvailable()) {
                return "?";
            }
            command.add("-v", "error", "-show_entries", "format=duration", "-of", "default=noprint_wrappers=1:nokey=1", "-sexagesimal");
            command.add(inputFile);
            ProcessBuilder builder = new ProcessBuilder(command.build());
            builder.redirectErrorStream(true);
            Process process = builder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                int last = line.lastIndexOf(".");
                if (line.indexOf(":") == -1) continue;
                String value = line.substring(0, last);
                return this.format(value);
            }
            return "?";
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return "?";
        }
    }

    private String format(String value) {
        if (value.length() < 8) {
            String[] split = value.split(":");
            Object result = "";
            for (String s : split) {
                result = s.length() == 2 ? (String)result + s : (String)result + "0" + s;
                if (((String)result).length() >= 7) continue;
                result = (String)result + ":";
            }
            return result;
        }
        return value;
    }
}

