/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ffmpeg;

import de.mallongigi.ffmpeg.AbstractFFMPEG;
import de.mallongigi.ffmpeg.FFMPEGCommand;
import de.mallongigi.ffmpeg.FFMPEGExecuteFactory;
import de.mallongigi.ffmpeg.FFMPEGTools;
import de.mallongigi.file.FileUtil;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.progress.AbstractOpenDirectoryHandler;
import de.mallongigi.resource.language.LanguageKeys;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FFMPEGFileConverter
extends AbstractFFMPEG {
    private static final Logger LOG = Logger.getLogger(FFMPEGFileConverter.class.getName());
    private final AbstractOpenDirectoryHandler handler;

    public FFMPEGFileConverter(AbstractOpenDirectoryHandler handler) {
        super(handler.getProgressModel());
        this.handler = handler;
    }

    @Override
    public void start() {
        try {
            PodcastEpisodeModel episode = (PodcastEpisodeModel)this.model.getModel();
            String url = episode.getUrl();
            String type = FileUtil.getFileFormat(url);
            if (type == null && (type = this.getEpisodeEncoding()) == null) {
                type = "mp4";
            }
            Path inputFile = episode.getChannel().getPodcastFilenameConverter().convertEpisode(episode);
            Path outputFile = episode.getChannel().getPodcastFilenameConverter().convertToMP3File(episode);
            if (Files.exists(outputFile, new LinkOption[0]) || !Files.exists(inputFile, new LinkOption[0])) {
                return;
            }
            FFMPEGCommand command = new FFMPEGCommand(FFMPEGTools.ffmpeg);
            command.add("-i");
            command.add(inputFile);
            if (type.equals("m4a")) {
                command.add("-acodec", "libmp3lame", "-aq", "2");
            }
            command.add(outputFile);
            new FFMPEGExecuteFactory().create().execute(command, this.process, this.handler);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            new File(this.outputFile).delete();
            this.model.setErrorMessage(LanguageKeys.errorConvertFile);
            this.model.setErrorMessageDetails(e);
        }
    }

    public String getEpisodeEncoding() {
        String format = ((PodcastEpisodeModel)this.handler.getProgressModel().getModel()).getMediaType();
        if (format == null) {
            return null;
        }
        int pos = format.indexOf("/");
        if (pos == -1) {
            return null;
        }
        return format.substring(pos + 1, format.length());
    }
}

