/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ffmpeg;

import de.mallongigi.ffmpeg.AbstractFFMPEG;
import de.mallongigi.ffmpeg.FFMPEGCommand;
import de.mallongigi.ffmpeg.FFMPEGExecuteFactory;
import de.mallongigi.ffmpeg.FFMPEGTools;
import de.mallongigi.file.PodcastFilenameConverter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.progress.AbstractOpenDirectoryHandler;
import de.mallongigi.resource.language.LanguageKeys;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FFMPEGClearMP3File
extends AbstractFFMPEG {
    private static final Logger LOG = Logger.getLogger(FFMPEGClearMP3File.class.getName());
    private final AbstractOpenDirectoryHandler handler;

    public FFMPEGClearMP3File(AbstractOpenDirectoryHandler handler) {
        super(handler.getProgressModel());
        this.handler = handler;
    }

    @Override
    public void start() {
        try {
            PodcastEpisodeModel episode = (PodcastEpisodeModel)this.model.getModel();
            Path outputFile = new PodcastFilenameConverter().convertToClearMP3Filename(episode);
            Path inputFile = episode.getChannel().getPodcastFilenameConverter().convertEpisode(episode);
            if (outputFile.toFile().exists() || !Files.exists(inputFile, new LinkOption[0])) {
                return;
            }
            FFMPEGCommand command = new FFMPEGCommand(FFMPEGTools.ffmpeg);
            command.add("-i").add(inputFile).add(outputFile);
            new FFMPEGExecuteFactory().create().execute(command, this.process, this.handler);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            new File(this.outputFile).delete();
            this.model.setErrorMessage(LanguageKeys.errorConvertFile);
            this.model.setErrorMessageDetails(e);
        }
    }
}

