/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.errorhandling;

import de.mallongigi.errorhandling.ErrorMessage;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public final class ErrorContainer {
    private List<ErrorMessage> errors = new ArrayList<ErrorMessage>();
    @Inject
    private LanguageResource languageResource;

    private ErrorContainer() {
    }

    public String add(LanguageKeys key, Object ... objects) {
        ErrorMessage message = new ErrorMessage(key, objects);
        if (this.errors.contains(message)) {
            return this.languageResource.messageForKey(message.errorKey(), message.detailText());
        }
        this.errors.add(message);
        return this.languageResource.messageForKey(message.errorKey(), message.detailText());
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (ErrorMessage error : this.errors) {
            if (error.detailText() == null) {
                b.append(this.languageResource.messageForKey(error.errorKey()) + "\n");
                continue;
            }
            b.append(this.languageResource.messageForKey(error.errorKey(), error.detailText()) + "\n");
        }
        return b.toString();
    }

    public void clear() {
        this.errors.clear();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

