/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.dialog;

import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.channel.navigation.PodcastChannelNavigationModel;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.style.Styles;
import java.util.Optional;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextInputDialog;
import javafx.scene.input.Clipboard;

public final class PodcastAddFeedDialog {
    @Inject
    private PodcastChannelNavigationModel podcastChannelNavigationModel;
    @Inject
    private OSPlatform osPlatform;
    @Inject
    private Styles styles;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private LanguageResource languageResource;

    public PodcastAddFeedDialog() {
        Container.inject(this);
    }

    public String insertPodcastUrl(LanguageKeys windowsTitle) {
        this.podcastChannelNavigationModel.clearFilter();
        Clipboard clipboard = Clipboard.getSystemClipboard();
        String cString = clipboard.getString();
        if (cString == null || !cString.startsWith("http")) {
            cString = "";
        }
        TextInputDialog dialog = new TextInputDialog(cString);
        this.styles.setStyle(dialog.getDialogPane());
        this.styles.setWindowIcon(dialog.getDialogPane(), DefaultIcons.AddPodcast);
        dialog.getDialogPane().setMinWidth(400.0);
        dialog.setTitle(this.languageResource.messageForKey(windowsTitle));
        dialog.setHeaderText(this.languageResource.messageForKey(LanguageKeys.insertPodcastURL));
        dialog.setContentText(this.languageResource.messageForKey(LanguageKeys.podcastURL));
        dialog.setGraphic(this.iconFactory.create(DefaultIcons.AddPodcast, 48));
        this.osPlatform.setDarkMode((Dialog<?>)dialog);
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            String value = (String)result.get();
            if (value.trim().length() == 0) {
                return null;
            }
            return value;
        }
        return null;
    }
}

