/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.dialog;

import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.style.Styles;
import java.util.ArrayList;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;

public final class InitialLoadFeedDataDialog
extends Alert {
    private TextArea textArea;
    private int success = 0;
    private int fail = 0;
    @Inject
    private OSPlatform osPlatform;
    @Inject
    private Styles styles;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private LanguageResource languageResource;

    public InitialLoadFeedDataDialog(DefaultIcons image) {
        super(Alert.AlertType.INFORMATION);
        Container.inject((Object)this);
        this.init(image);
    }

    private void init(DefaultIcons image) {
        this.styles.setStyle(this.getDialogPane());
        this.styles.setWindowIcon(this.getDialogPane(), image);
        this.setTitle(this.languageResource.messageForKey(LanguageKeys.addPodcast));
        this.setHeaderText(this.languageResource.messageForKey(LanguageKeys.loadFeedData));
        this.setGraphic(this.iconFactory.create(DefaultIcons.AddPodcast, 48));
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        this.textArea.setWrapText(true);
        this.textArea.setMaxWidth(Double.MAX_VALUE);
        this.textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)this.textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)this.textArea, 0, 2);
        this.getDialogPane().setExpandableContent((Node)expContent);
        this.getDialogPane().lookupButton(ButtonType.OK).setDisable(true);
        this.osPlatform.setDarkMode((Dialog<?>)this);
    }

    public boolean hasInformation() {
        return this.textArea.getText().trim().length() > 0;
    }

    public void addInformation(String value) {
        String current = this.textArea.getText() + "\n" + value;
        this.textArea.setText(current);
    }

    public void addFail() {
        ++this.fail;
    }

    public void addSuccess() {
        ++this.success;
    }

    public void enableButton() {
        this.getDialogPane().lookupButton(ButtonType.OK).setDisable(false);
    }

    public void showFinishMessage() {
        this.setHeaderText(this.languageResource.messageForKey(LanguageKeys.importFinishMessage, this.success, this.fail));
    }

    public String selectAlternative(PodcastChannelModel model) {
        String url;
        ArrayList<String> list = new ArrayList<String>();
        for (String s : model.getAlternativ().keySet()) {
            list.add(s);
        }
        ChoiceDialog dialog = new ChoiceDialog((Object)(this.languageResource.messageForKey(LanguageKeys.currentFeed) + "=" + model.getPodcastFeedUrl()), list);
        Stage stage = (Stage)dialog.getDialogPane().getScene().getWindow();
        this.styles.setStyle(dialog.getDialogPane());
        stage.getIcons().add((Object)this.iconFactory.createIcon(DefaultIcons.Ok_window_icon, 16));
        stage.setTitle(this.languageResource.messageForKey(LanguageKeys.confirmPodcastTypeSelection));
        dialog.setGraphic(this.iconFactory.create(DefaultIcons.Import, 48));
        dialog.setHeaderText(model.getTitle());
        dialog.setContentText(this.languageResource.messageForKey(LanguageKeys.selectFeed));
        Optional result = dialog.showAndWait();
        if (result.isPresent() && (url = model.getAlternativ().get(result.get())) != null) {
            return url;
        }
        return model.getPodcastFeedUrl();
    }
}

